/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.Material;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.decorative.Plant;
import com.github.fnar.minecraft.block.decorative.Skull;
import com.github.fnar.minecraft.block.spawner.Spawner;
import com.github.fnar.minecraft.item.RldItemStack;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.PositionInfo;
import greymerk.roguelike.worldgen.VanillaStructure;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public interface WorldEditor {
    public static final int FURNACE_FUEL_SLOT = 1;

    public void generateSpawner(Spawner var1, Coord var2);

    public boolean isSolidBlock(Coord var1);

    public boolean isOpaqueBlock(Coord var1);

    public boolean isOpaqueCubeBlock(Coord var1);

    public boolean isBlockOfTypeAt(BlockType var1, Coord var2);

    public boolean isMaterialAt(Material var1, Coord var2);

    public Random getRandom();

    public Random getRandom(Coord var1);

    public boolean setBlock(Coord var1, SingleBlockBrush var2, boolean var3, boolean var4);

    public boolean isAirBlock(Coord var1);

    public long getSeed();

    public void fillDown(Coord var1, BlockBrush var2);

    public TileEntity getTileEntity(Coord var1);

    public boolean isValidGroundBlock(Coord var1);

    public Map<BlockType, Integer> getStats();

    public boolean canPlace(SingleBlockBrush var1, Coord var2, Direction var3);

    public PositionInfo getInfo(Coord var1);

    public Coord findNearestStructure(VanillaStructure var1, Coord var2);

    public void setBedColorAt(Coord var1, DyeColor var2);

    public void setItem(Coord var1, int var2, ItemStack var3);

    public void setItem(Coord var1, int var2, RldItemStack var3);

    public void setFlowerPotContent(Coord var1, Plant var2);

    public void setSkull(WorldEditor var1, Coord var2, Direction var3, Skull var4);

    public void setLootTable(Coord var1, String var2);

    default public int getSeed(Coord coord) {
        return Objects.hash(coord.hashCode(), this.getSeed());
    }

    public int getCapacity(TreasureChest var1);

    public boolean isEmptySlot(TreasureChest var1, int var2);

    public TreasureManager getTreasureManager();
}

